<?php defined('SYSPATH') or die('No direct script access.');

class create_table_logpost_mini extends Migration{

    public $table = 'logpost_mini';

    public function up(){
        $this->add_action(
            'Logpost/Mini',
            'Logpost for role mini-user',
            'Logpost',
            'mini-user'
        );

        $this->add_action(
            'Logpost/Mini edit',
            'Logpost edit for role mini-user',
            'Logpost',
            'admin'
        );

        /* table */
        $this->create_table($this->table, [
            'id' => ['integer'],
            'user_id' => ['integer'],
        ], false);

        $this->add_index($this->table, 'logpost_mini_id_idx', ['id']);
        $this->add_index($this->table, 'logpost_mini_user_id_idx', ['user_id']);
        $this->add_index($this->table, 'logpost_mini_id_user_id_idx', ['id', 'user_id']);
    }

    public function down(){
        $this->del_action('Logpost/Mini');
        $this->del_action('Logpost/Mini edit');

        /* table */
        $this->drop_table($this->table);
    }

    private function add_action($name, $description, $menu_title, $role){
        $action = ORM::factory('Action');
        $action->name = $name;
        $action->description = $description;
        $action->menu_title = $menu_title;
        $action->save();

        $role = ORM::factory('Role', ['name' => $role]);
        $role->add('actions', $action);
    }

    private function del_action($action_name){
        $action = ORM::factory('Action', ['name' => $action_name]);
        $action_roles = ORM::factory('Action_Role')
            ->where('action_id', '=', $action->id)
            ->find_all();
        foreach($action_roles as $action_role) {
            $action_role->delete();
        }
        $action->delete();
    }
}